VERSION 2.00
Begin Form frmMain 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Synchronize Directories"
   ClientHeight    =   4320
   ClientLeft      =   2055
   ClientTop       =   1485
   ClientWidth     =   5295
   Height          =   4725
   HelpContextID   =   1
   Icon            =   SD_MAIN.FRX:0000
   Left            =   1995
   LinkTopic       =   "Form1"
   ScaleHeight     =   4320
   ScaleWidth      =   5295
   Top             =   1140
   Width           =   5415
   Begin TextBox txtIgnrType 
      Height          =   285
      HelpContextID   =   206
      Left            =   2760
      TabIndex        =   4
      Text            =   "txtIgnrType"
      Top             =   2760
      Width           =   2415
   End
   Begin CheckBox chkCopyOld 
      BackColor       =   &H00C0C0C0&
      Caption         =   " Copy older files"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Arial"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      HelpContextID   =   203
      Left            =   120
      TabIndex        =   5
      Top             =   3120
      Width           =   2415
   End
   Begin CommandButton btnHelp 
      Caption         =   "Help"
      Height          =   375
      Left            =   120
      TabIndex        =   8
      Top             =   3840
      Width           =   855
   End
   Begin CheckBox chkSyncBoth 
      BackColor       =   &H00C0C0C0&
      Caption         =   " Synchronize both ways"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Arial"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      HelpContextID   =   204
      Left            =   120
      TabIndex        =   6
      Top             =   3480
      Width           =   2415
   End
   Begin CheckBox chkDelXtra 
      BackColor       =   &H00C0C0C0&
      Caption         =   " Delete extra files"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Arial"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      HelpContextID   =   205
      Left            =   2760
      TabIndex        =   7
      Top             =   3480
      Width           =   2415
   End
   Begin CommandButton btnExit 
      Cancel          =   -1  'True
      Caption         =   "Exit"
      Height          =   375
      Left            =   4320
      TabIndex        =   10
      Top             =   3840
      Width           =   855
   End
   Begin CommandButton btnSync 
      Caption         =   "Synchronize"
      Default         =   -1  'True
      Height          =   375
      Left            =   1920
      TabIndex        =   9
      Top             =   3840
      Width           =   1455
   End
   Begin DirListBox dirTrgt 
      Height          =   1605
      HelpContextID   =   202
      Left            =   2760
      TabIndex        =   2
      Top             =   480
      Width           =   2415
   End
   Begin DirListBox dirSrc 
      Height          =   1605
      HelpContextID   =   201
      Left            =   120
      TabIndex        =   0
      Top             =   480
      Width           =   2415
   End
   Begin DriveListBox drvTrgt 
      Height          =   315
      HelpContextID   =   202
      Left            =   2760
      TabIndex        =   3
      Top             =   2280
      Width           =   2415
   End
   Begin DriveListBox drvSrc 
      Height          =   315
      HelpContextID   =   201
      Left            =   120
      TabIndex        =   1
      Top             =   2280
      Width           =   2415
   End
   Begin Label Label3 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Ignore File Types:"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Arial"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   120
      TabIndex        =   13
      Top             =   2760
      Width           =   2535
   End
   Begin Label Label2 
      BackStyle       =   0  'Transparent
      Caption         =   "Target Directory:"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Arial"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   2760
      TabIndex        =   12
      Top             =   120
      Width           =   1575
   End
   Begin Label Label1 
      BackStyle       =   0  'Transparent
      Caption         =   "Source Directory:"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "Arial"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   255
      Left            =   120
      TabIndex        =   11
      Top             =   120
      Width           =   1575
   End
End
Option Explicit

Sub btnExit_Click ()
     End  ' Stop program execution
End Sub

Sub btnHelp_Click ()
    SendKeys "{F1}"
End Sub

Sub btnSync_Click ()
    Dim sSrcDir As String    ' Source Directory
    Dim sTrgtDir As String   ' Target Directory
    Dim nSync As Integer     ' # Files affected
    
    btnSync.Enabled = False

    Call InitializeLogText
    
    sSrcDir = dirSrc.Path
    sTrgtDir = dirTrgt.Path

    If sSrcDir = sTrgtDir Then
        nSync = 0
        Beep
        MsgBox "The source directory and target directory are the same: " & UCase$(sSrcDir), MB_ICONINFORMATION, "Directory Synchronization Utility"
    Else
        nSync = nSynchronizeDirectories(gbCopyOld, gbDelXtra, sSrcDir, sTrgtDir, txtIgnrType)
        
        If gbSyncBoth Then  ' Sync. in opposite direction
            nSync = nSync + nSynchronizeDirectories(gbCopyOld, gbDelXtra, sTrgtDir, sSrcDir, txtIgnrType)
        End If
    End If
    
    If (gbNtfyUser Or (Not gbAutoSync)) And (nSync > 0) Then
        frmLog.Show  ' Will exit program when closed, if gbAutoSync is true
    ElseIf gbAutoSync Then
        Call ExecuteRunCommand
        End  ' Exit program
    End If

    btnSync.Enabled = True
End Sub

Sub chkCopyOld_Click ()
    If chkCopyOld = CHECKED Then
        gbCopyOld = True
    Else
        gbCopyOld = False
    End If
End Sub

Sub chkDelXtra_Click ()
    If chkDelXtra = CHECKED Then
        gbDelXtra = True
        chkSyncBoth = UNCHECKED  ' Cannot have both true
    Else
        gbDelXtra = False
    End If
End Sub

Sub chkSyncBoth_Click ()
    If chkSyncBoth = CHECKED Then
        gbSyncBoth = True
        chkDelXtra = UNCHECKED  ' Cannot have both true
    Else
        gbSyncBoth = False
    End If
End Sub

Sub drvSrc_Change ()
    dirSrc.Path = Left$(drvSrc.Drive, 1) & ":"
End Sub

Sub drvTrgt_Change ()
    dirTrgt.Path = Left$(drvTrgt.Drive, 1) & ":"
End Sub

Sub Form_Load ()
    Dim s As String

    s = sInitializationEntry("Automatic", "NO")
    If (s = "YES") Or (s = "TRUE") Or (s = "1") Then
        gbAutoSync = True
    Else
        gbAutoSync = False
    End If

    s = sInitializationEntry("NotifyUser", "YES")
    If (s = "YES") Or (s = "TRUE") Or (s = "1") Then
        gbNtfyUser = True
    Else
        gbNtfyUser = False
    End If
    
    gsRunDir = sInitializationEntry("RunDirectory", "")
    gsRunCmd = sInitializationEntry("RunCommand", "")
    
    s = sInitializationEntry("SourceDirectory", "")
    If s <> "" Then
        If InStr(s, ":") = 0 Then
            s = gsInitDrv & s
        End If
        
        On Error Resume Next
            dirSrc.Path = s
            If Err <> 0 Then
                Beep
                MsgBox "Not a valid source directory: " & UCase$(s), MB_ICONEXCLAMATION, "Directory Synchronization Utility"
                gbAutoSync = False  ' Popup selection form due to error
            End If
            drvSrc.Drive = Left$(s, 1)
        On Error GoTo 0
    End If

    s = sInitializationEntry("TargetDirectory", "")
    If s <> "" Then
        If InStr(s, ":") = 0 Then
            s = gsInitDrv & s
        End If
        
        On Error Resume Next
            dirTrgt.Path = s
            If Err <> 0 Then
                Beep
                MsgBox "Not a valid target directory: " & UCase$(s), MB_ICONEXCLAMATION, "Directory Synchronization Utility"
                gbAutoSync = False  ' Popup selection form due to error
            End If
            drvTrgt.Drive = Left$(s, 1)
        On Error GoTo 0
    End If

    s = sInitializationEntry("IgnoreFileTypes", "")
    txtIgnrType = s

    s = sInitializationEntry("CopyOlderFiles", "NO")
    If (s = "YES") Or (s = "TRUE") Or (s = "1") Then
        gbCopyOld = True
        chkCopyOld = CHECKED
    Else
        gbCopyOld = False
        chkCopyOld = UNCHECKED
    End If

    s = sInitializationEntry("SynchronizeBothWays", "NO")
    If (s = "YES") Or (s = "TRUE") Or (s = "1") Then
        gbSyncBoth = True
        chkSyncBoth = CHECKED
    Else
        gbSyncBoth = False
        chkSyncBoth = UNCHECKED
    End If

    s = sInitializationEntry("DeleteExtraFiles", "NO")
    If (s = "YES") Or (s = "TRUE") Or (s = "1") Then
        If gbSyncBoth Then  ' Cannot both be true
            gbDelXtra = False
            chkDelXtra = UNCHECKED
            Beep
            MsgBox "Initialization setup error in file " & UCase$(gsInitFile) & ": SynchronizeBothWays and DeleteExtraFiles cannot both be enabled", MB_ICONEXCLAMATION, "Directory Synchronization Utility"
            gbAutoSync = False  ' Popup selection form due to error
        Else
            gbDelXtra = True
            chkDelXtra = CHECKED
        End If
    Else
        gbDelXtra = False
        chkDelXtra = UNCHECKED
    End If
                

    If gbAutoSync Then
        btnSync_Click
    Else
        Me.Show
    End If
End Sub

